/**
 * External dependencies
 */
const _ = window.lodash;

/**
 * WordPress dependencies
 */
const { __ } = wp.i18n;
const { Spinner } = wp.components;
const { withSelect } = wp.data;

/**
 * Internal dependencies
 */
import { getOption, pluginUrl } from 'utils';

const articlesSelect = (select) => {
    return {
        posts: select('core').getEntityRecords('postType', getOption('article_cpt'), { per_page: -1 })
    };
};

export const RelatedPreview = withSelect(articlesSelect)(({ posts, title, mode, ids, limit }) => {
    let selected = ids.split(',').filter(Boolean).map(Number);

    if ('manual' === mode) {
        if (0 === selected.length ) {
            return <p>{__('No articles selected', 'minerva-kb')}</p>;
        }

        if (!posts) {
            return (
                <p>
                    <Spinner />
                    {__( 'Loading Articles...', 'minervakb' )}
                </p>
            );
        }

        if (0 === posts.length ) {
            return <p>{__('No articles', 'minerva-kb')}</p>;
        }

        selected = selected.map(articleId => _.find(posts, { id: articleId })).filter(Boolean);
    } else if ('topic' === mode) {
        selected = [
            { title: { rendered: 'Preview Topic Article 1' }},
            { title: { rendered: 'Preview Topic Article 2' }},
            { title: { rendered: 'Preview Topic Article 3' }},
            { title: { rendered: 'Preview Topic Article 4' }},
            { title: { rendered: 'Preview Topic Article 5' }},
            { title: { rendered: 'Preview Topic Article 6' }},
            { title: { rendered: 'Preview Topic Article 7' }},
            { title: { rendered: 'Preview Topic Article 8' }},
            { title: { rendered: 'Preview Topic Article 9' }},
            { title: { rendered: 'Preview Topic Article 10' }},
        ];

        if (limit && String(limit) !== '-1') {
            selected = selected.slice(0, Number(limit));
        }
    }

    return selected.length && (
        <div className="mkb-related-content">
            <div className="mkb-related-content-title">{title ? title : getOption('related_content_label')}</div>
            <ul className="mkb-related-content-list">
                {selected.map(article => <li><a>{article.title.rendered}</a></li>)}
            </ul>
        </div>
    );
});